/*
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 * Gary Jennejohn <gj@denx.de>
 * David Mueller <d.mueller@elsoft.ch>
 *
 * Configuation settings for the W5300E01 board.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __CONFIG_H
#define __CONFIG_H

#define FIRMWARE_VER			1
/*
 * select boot device
 */
#define CONFIG_BOOT_DEVICE_NAND

/*
 * If we are developing, we might want to start armboot from ram
 * so we MUST NOT initialize critical regs like mem-timing ...
 */
#define CONFIG_INIT_CRITICAL		/* undef for developing */

/*
 * High Level Configuration Options
 * (easy to change)
 */
#define CONFIG_ARM920T		1	/* This is an ARM920T Core	*/
#define	CONFIG_S3C2410		1	/* in a SAMSUNG S3C2410 SoC     */
#define CONFIG_W5300E01		1

/* input clock of PLL */
#define CONFIG_SYS_CLK_FREQ	12000000/* 12MHz input clock */
#define CONFIG_SETUP_MEMORY_TAGS	1
#define CONFIG_CMDLINE_TAG	1


#define USE_920T_MMU		1
#undef CONFIG_USE_IRQ			/* we don't need IRQ/FIQ stuff */

/*
 * Size of malloc() pool
 */
#define CFG_MALLOC_LEN		(CFG_ENV_SIZE + 128*1024)
#define CFG_GBL_DATA_SIZE	128	/* size in bytes reserved for initial data */

/*
 * Hardware drivers
 */
#define CONFIG_DRIVER_W5300	1
#define W5300_BASE		0x10000000
#define W5300_MAX_CHANNEL	2
#define W5300_TMSR_ARRAY	{32,32}
#define W5300_RMSR_ARRAY	{32,32}

/*
 * select serial console configuration
 */
#define CONFIG_SERIAL1          1	/* we use SERIAL 1 */

/************************************************************
 * RTC
 ************************************************************/
#define	CONFIG_RTC_S3C24X0		1

/* allow to overwrite serial and ethaddr */
#define CONFIG_ENV_OVERWRITE		1

#define CONFIG_BAUDRATE		115200

/***********************************************************
 * Command definition
 ***********************************************************/
#define REMOVE_COMMANDS \
			(CFG_CMD_FLASH	|\
			CFG_CMD_LOADUB	|\
			CFG_CMD_IMLS)

#define CONFIG_COMMANDS \
			( (CONFIG_CMD_DFL & ~REMOVE_COMMANDS)	| \
			CFG_CMD_CACHE	| \
			CFG_CMD_NAND	| \
			CFG_CMD_ENV	| \
			CFG_CMD_NET	| \
			CFG_CMD_PING	| \
			CFG_CMD_DHCP	| \
			CFG_CMD_REGINFO	| \
			CFG_CMD_DATE	| \
			CFG_CMD_ELF)

/* this must be included AFTER the definition of CONFIG_COMMANDS (if any) */
#include <cmd_confdefs.h>

#define CONFIG_BOOTDELAY	3
#define CONFIG_BOOTARGS    	""
#define CONFIG_ETHADDR  00:08:dc:00:00:00
#define CONFIG_NETMASK  255.255.255.0
#define CONFIG_IPADDR   192.168.1.3
#define CONFIG_SERVERIP 192.168.1.2
#define CONFIG_GATEWAYIP  192.168.1.1
#define CONFIG_BOOTFILE		""
#define CONFIG_BOOTCOMMAND	"nand read 30400000 400000 c00000;nand read 32000000 40000 2eb958;bootm 32000000"

#if (CONFIG_COMMANDS & CFG_CMD_LOADUB)
#define CONFIG_DRIVER_USB_DEVICE
#define CONFIG_LOADUB_PATH	""	/* loadub default path */
#endif

/*
 * Miscellaneous configurable options
 */
#define	CFG_LONGHELP				/* undef to save memory		*/
#define	CFG_PROMPT		"WIZnet # "	/* Monitor Command Prompt	*/
#define	CFG_CBSIZE		256		/* Console I/O Buffer Size	*/
#define	CFG_PBSIZE (CFG_CBSIZE+sizeof(CFG_PROMPT)+16) /* Print Buffer Size */
#define	CFG_MAXARGS		16		/* max number of command args	*/
#define CFG_BARGSIZE		CFG_CBSIZE	/* Boot Argument Buffer Size	*/

#define CFG_MEMTEST_START	0x30000000	/* memtest works on	*/
#define CFG_MEMTEST_END		0x33F00000	/* 63 MB in DRAM	*/

#undef  CFG_CLKS_IN_HZ		/* everything, incl board info, in Hz */

#define	CFG_LOAD_ADDR		0x31000000	/* default load address	*/

/* autoload */
#define CFG_AUTOLOAD		"no"

/* the PWM TImer 4 uses a counter of 15625 for 10 ms, so we need */
/* it to wrap 100 times (total 1562500) to get 1 sec. */
#define	CFG_HZ			1562500

/* valid baudrates */
#define CFG_BAUDRATE_TABLE	{ 9600, 19200, 38400, 57600, 115200 }

/*-----------------------------------------------------------------------
 * Stack sizes
 *
 * The stack sizes are set up in start.S using the settings below
 */
#define CONFIG_STACKSIZE	(128*1024)	/* regular stack */
#ifdef CONFIG_USE_IRQ
#define CONFIG_STACKSIZE_IRQ	(4*1024)	/* IRQ stack */
#define CONFIG_STACKSIZE_FIQ	(4*1024)	/* FIQ stack */
#endif

/*-----------------------------------------------------------------------
 * Physical Memory Map
 */
#define CONFIG_NR_DRAM_BANKS	1	   /* we have 1 bank of DRAM */
#define PHYS_SDRAM_1		0x30000000 /* SDRAM Bank #1 */
//#define PHYS_SDRAM_1_SIZE	0x02000000 /* 32 MB */
#define PHYS_SDRAM_1_SIZE	0x04000000 /* 64 MB */

/*-----------------------------------------------------------------------
 * FLASH organization
 */
#define CFG_NO_FLASH            1       /* no flash */

#undef CONFIG_AMD_LV160	/* define this if you have a LV160 flash */
#undef CONFIG_AMD_LV800		/* define this if you have a LV800 flash */
#undef CONFIG_AMD_LV400		/* define this if you have a LV400 flash */

#define CFG_MAX_FLASH_BANKS	0	/* max number of memory banks */

#if defined(CONFIG_AMD_LV160)
#define PHYS_FLASH_SIZE		0x00200000 /* 2MB */
#define CFG_MAX_FLASH_SECT	(35)	/* max number of sectors on one chip */
#define CFG_FLASH_ENV_ADDR	(CFG_FLASH_BASE + 0x020000) /* addr of environment */
#elif defined(CONFIG_AMD_LV800)
#define PHYS_FLASH_SIZE		0x00100000 /* 1MB */
#define CFG_MAX_FLASH_SECT	(19)	/* max number of sectors on one chip */
#define CFG_FLASH_ENV_ADDR	(CFG_FLASH_BASE + 0x020000) /* addr of environment */
#elif defined(CONFIG_AMD_LV400)
#define PHYS_FLASH_SIZE		0x00080000 /* 512KB */
#define CFG_MAX_FLASH_SECT	(11)	/* max number of sectors on one chip */
#define CFG_FLASH_ENV_ADDR	(CFG_FLASH_BASE + 0x020000) /* addr of environment */
#else
//#error "FLAH NOT DEFINED!"
#endif

/* timeout values are in ticks */
#define CFG_FLASH_ERASE_TOUT	(5*CFG_HZ) /* Timeout for Flash Erase */
#define CFG_FLASH_WRITE_TOUT	(5*CFG_HZ) /* Timeout for Flash Write */

/*-----------------------------------------------------------------------
 * NAND FLASH organization
 */
#define CFG_MAX_NAND_DEVICE   1    /* Max number of NAND devices      */
#define SECTORSIZE 512

#define ADDR_COLUMN 1
#define ADDR_PAGE 3
#define ADDR_COLUMN_PAGE 4

#define NAND_ChipID_UNKNOWN   0x00
#define NAND_MAX_FLOORS 1
#define NAND_MAX_CHIPS 1

#define bRnB        (1<<0)

#define NAND_DISABLE_CE(nand)           __raw_writel((__raw_readl(nand->IO_ADDR) | (1<<11)), nand->IO_ADDR)
#define NAND_ENABLE_CE(nand)            __raw_writel((__raw_readl(nand->IO_ADDR) & ~(1<<11)), nand->IO_ADDR)

#define NAND_WAIT_READY(nand)           while (!(__raw_readl(nand->IO_ADDR+0x10) & bRnB))

#define WRITE_NAND_COMMAND(d, adr)      do{ *(volatile __u8 *)((unsigned long)(adr+4)) = (__u8)(d); } while(0)
#define WRITE_NAND_ADDRESS(d, adr)      do{ *(volatile __u8 *)((unsigned long)(adr+8)) = (__u8)(d); } while(0)
#define WRITE_NAND(d, adr)              do{ *(volatile __u8 *)((unsigned long)(adr+12)) = (__u8)d; } while(0)
#define READ_NAND(adr)                  ((volatile unsigned char)(*(volatile __u8 *)(unsigned long)(adr+12)))

/* the following are NOP's in our implementation */
#define NAND_CTL_CLRALE(nandptr)
#define NAND_CTL_SETALE(nandptr)
#define NAND_CTL_CLRCLE(nandptr)
#define NAND_CTL_SETCLE(nandptr)

/*-----------------------------------------------------------------------
 * environment organization
 */
// eou4
#if 1
#ifdef CONFIG_BOOT_DEVICE_NAND
#undef  CFG_ENV_IS_IN_FLASH
#define CFG_ENV_IS_IN_NAND
#else
#define  CFG_ENV_IS_IN_FLASH
#undef CFG_ENV_IS_IN_NAND
#endif /* CONFIG_BOOT_DEVICE_NAND */
#endif
//#define CFG_ENV_IS_NOWHERE

#if defined(CFG_ENV_IS_IN_FLASH)
	#define CFG_ENV_ADDR		(CFG_FLASH_ENV_ADDR)
	#define	CFG_ENV_SIZE		0x10000		/* Total Size of Environment Sector */
#elif defined(CFG_ENV_IS_IN_NAND)
	#define CFG_ENV_ADDR            0x20000         /* addr of environment in NAND */
							/* align to SECTORSIZE(512,0x200) */
	#define CFG_ENV_SIZE            0x4000          /* Total Size of Environment Sector */
							/* align to SECTORSIZE(512,0x200) */
#else
//eou4
//#error "ENVIRONMENT DEVICE NOT DEFINED!"
#define CFG_ENV_SIZE            0x10000
#endif

// eou4
//#define CFG_CONSOLE_IS_IN_ENV
#endif	/* __CONFIG_H */
