/*
 * (C) Copyright 2005
 * DIGNSYS Inc. < www.dignsys.com >
 * Kane Ahn     < hbahn@dignsys.com >
 *
 * Configuation settings for the dignsys iview board.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __CONFIG_H
#define __CONFIG_H

/*
 * If we are developing, we might want to start armboot from ram
 * so we MUST NOT initialize critical regs like mem-timing ...
 */
#define CONFIG_INIT_CRITICAL            /* undef for developing */

/*
 * High Level Configuration Options
 * (easy to change)
 */
#define CONFIG_ARM940T		1	/* This is a ARM946ES CPU	*/
#define	CONFIG_S3C2500		1	/* in a SEC S3C2500 SoC     */

#undef CONFIG_USE_IRQ			/* don't need them anymore */

/*
 * Size of malloc() pool
 */
#define CFG_MALLOC_LEN		(CFG_ENV_SIZE + 128*1024)
#define CFG_GBL_DATA_SIZE	128	/* size in bytes reserved for initial data */

/*
 * Hardware drivers
 */
#define	CONFIG_DRIVER_S3C2500		/* Using S3C2500 internal ethernet controller */

/*
 * select serial console configuration
 */
#define CONFIG_SERIAL1		1	/* we use Serial line 1 */
#define CONFIG_BAUDRATE		115200

/* allow to overwrite serial and ethaddr */
#define CONFIG_ENV_OVERWRITE

/*
 * Command definition
 */
/***********************************************************
 * Command definition
 ***********************************************************/
#define	CONFIG_COMMANDS 	\
		(		\
/*		CFG_CMD_NAND	 | \
		CFG_CMD_LOADUB	 | */ \
		CONFIG_CMD_DFL)

/* this must be included AFTER the definition of CONFIG_COMMANDS (if any) */
#include <cmd_confdefs.h>

#if (CONFIG_COMMANDS & CFG_CMD_LOADUB)
#define	CONFIG_DRIVER_ML60852A			/* Using ML60852A	*/
#endif

#define	CONFIG_BOOTDELAY	3
#define	CONFIG_BOOTARGS    	"root=/dev/rom0 devfs=mount console=ttyS0,115200"
#define	CONFIG_ETHADDR		00:64:69:67:6e:73
#define	CONFIG_NETMASK		255.255.255.0
#define	CONFIG_IPADDR		192.168.1.11
#define	CONFIG_SERVERIP		192.168.1.10
#define	CONFIG_BOOTFILE		"uImage"
#define	CONFIG_BOOTCOMMAND	"tftpboot; bootm"
/*#define	CONFIG_BOOTCOMMAND	"tftpboot; bootm" */

#if (CONFIG_COMMANDS & CFG_CMD_KGDB)
#define CONFIG_KGDB_BAUDRATE	115200		/* speed to run kgdb serial port */
#define CONFIG_KGDB_SER_INDEX	2		/* which serial port to use */
#endif

#undef CONFIG_STATUS_LED

/*
 * Miscellaneous configurable options
 */
#define	CFG_LONGHELP				/* undef to save memory		*/
#define	CFG_PROMPT		"[S3C2500@DIGNSYS] # "		/* Monitor Command Prompt	*/
#define	CFG_CBSIZE		256		/* Console I/O Buffer Size	*/
#define	CFG_PBSIZE (CFG_CBSIZE+sizeof(CFG_PROMPT)+16) /* Print Buffer Size */
#define	CFG_MAXARGS		16		/* max number of command args	*/
#define CFG_BARGSIZE		CFG_CBSIZE	/* Boot Argument Buffer Size	*/

#define CFG_MEMTEST_START	0x00500000	/* memtest works on	*/
#define CFG_MEMTEST_END		0x00700000	/* 4 ... 8 MB in DRAM	*/

#undef  CFG_CLKS_IN_HZ		/* everything, incl board info, in Hz */

#define	CFG_LOAD_ADDR		0x00500000	/* default load address	*/

#define	CFG_HZ			133000000	/* decrementer freq: 1 MHz */
						/* valid baudrates */
#define CFG_BAUDRATE_TABLE	{ 9600, 19200, 38400, 57600, 115200 }

/*-----------------------------------------------------------------------
 * Stack sizes
 *
 * The stack sizes are set up in start.S using the settings below
 */
#define CONFIG_STACKSIZE	(128*1024)	/* regular stack */
#ifdef CONFIG_USE_IRQ
#define CONFIG_STACKSIZE_IRQ	(4*1024)	/* IRQ stack */
#define CONFIG_STACKSIZE_FIQ	(4*1024)	/* FIQ stack */
#endif

/*-----------------------------------------------------------------------
 * Physical Memory Map
 */
#define CONFIG_NR_DRAM_BANKS	1	   /* we have 1 banks of DRAM */
#define PHYS_SDRAM_1		0x00000000 /* SDRAM Bank #1 */
#define PHYS_SDRAM_1_SIZE	0x00800000 /* 8 MB */

#define PHYS_FLASH_1		0x80000000 /* remapped ROM bank 0 */
#define PHYS_FLASH_1_SIZE	0x00200000 /* 2 MB */

#define CFG_FLASH_BASE		PHYS_FLASH_1

/*-----------------------------------------------------------------------
 * IO Address
 */
#define CFG_NAND_BASE		0xF0000000 
#define CFG_GCS_BASE		0xF0004000 

/*-----------------------------------------------------------------------
 * FLASH and environment organization
 */
#undef CFG_FLASH_PROTECTION
#define CFG_MAX_FLASH_BANKS	1	/* max number of memory banks		*/
#define CFG_MAX_FLASH_SECT	1024	/* max number of sectors on one chip	*/

/* timeout values are in ticks */
#define CFG_FLASH_ERASE_TOUT	(10*CFG_HZ) /* Timeout for Flash Erase */
#define CFG_FLASH_WRITE_TOUT	(10*CFG_HZ) /* Timeout for Flash Write */

#define	CFG_ENV_IS_IN_FLASH	1
#define CFG_ENV_OFFSET		0x20000
#define CFG_ENV_ADDR		(CFG_FLASH_BASE + CFG_ENV_OFFSET)	/* Addr of Environment Sector	*/
#define CFG_ENV_SIZE		0x10000	/* Total Size of Environment Sector	*/

/* direct write data to flash device with TFTP loader */
#define CFG_DIRECT_FLASH_TFTP

/* Flash banks JFFS2 should use */
#define CFG_JFFS2_FIRST_BANK    0
#define CFG_JFFS2_FIRST_SECTOR	8
#define CFG_JFFS2_NUM_BANKS     2

#endif	/* __CONFIG_H */
