#ifndef __MAC_H
#define __MAC_H

/*******************************************************/
/* Buffered DMA	Trasmit	Control Register(BDMATXCONx)   */
/*******************************************************/
#define	BTxNBD		(6<<0)	// [3:0]BDMA Tx Number of Buffer Descriptor
				//      = 2^0, 2^1, 2^2, ...., 2^12
/* BDMA transmit to MAC Tx Start level(BTxMSL[6:4]) */
#define	BTxMSL000	(0<<4)	// No wait to fill the BDMA 
#define	BTxMSL001	(1<<4)	// wait to fill 1/8 of the BDMA 
#define	BTxMSL010	(2<<4)	// wait to fill 2/8 of the BDMA
#define	BTxMSL011	(3<<4)	// wait to fill 3/8 of the BDMA
#define	BTxMSL100	(4<<4)	// wait to fill 4/8 of the BDMA
#define	BTxMSL101	(5<<4)	// wait to fill 5/8 of the BDMA
#define	BTxMSL110	(6<<4)	// wait to fill 6/8 of the BDMA
#define	BTxMSL111	(7<<4)	// wait to fill 7/8 of the BDMA
#define	BTxEn		(1<<10)	// [10]BDMA Tx Enable 
#define	BTxRS		(1<<11)	// [11]BDMA Tx Reset 

/*********************************************************/
/* Buffered DMA Receiver Control Register (BDMARXCONx)   */ 
/*********************************************************/
#define	BRxNBD		(6<<0)	// [3:0]BDMA Rx Number of Buffer Descriptor
				//      = 2^0, 2^1, 2^2, ...., 2^12
#define BRxWA00		(0<<4)	// [5:4] BDMA Rx word alignment - no invalid byte
#define BRxWA01		(1<<4)	//     BDMA Rx Word Alignment - one invalid byte 
#define BRxWA10		(2<<4)	//     BDMA Rx Word Alignment - two invalid byte
#define BRxWA11		(3<<4)	//     BDMA Rx Word Alignment - three invalid byte 
#define	BRxEn		(1<<10)	// [10]BDMA Rx Enable
#define	BRxRS		(1<<11)	// [11]BDMA Rx Reset

/************************************************************/
/* BDMA/MAC Transmit Interrupt Enable Register (BMTXINTENx) */
/************************************************************/
#define	ExCollIE	(1<<0)	//[0] Enable MAC Tx excessive collision
#define	UnderflowIE	(1<<1)	//[1] Enable MAC Tx underflow
#define	DeferErrIE	(1<<2)	//[2] Enable MAC Tx deferral
#define	NoCarrIE	(1<<4)	//[4] Enable MAC Tx no carrier
#define	LateCollIE	(1<<5)	//[5] Enable MAC Tx late collision
#define	TxParErrIE	(1<<6)	//[6] Enable MAC Tx transmit parity
#define	TxCompIE	(1<<7)	//[7] Enable MAC Tx completion
#define	TxCFcompIE	(1<<16)	//[16] Enable Tx complete to send control frame
#define	BTxNOIE		(1<<17)	//[17] BDMA Tx not owner interrupt enable
#define	BTxEmptyIE	(1<<18)	//[18] BDMA Tx buffer empty interrupt enable

/************************************************************/
/* BDMA/MAC Transmit Interrupt Status Register (BMTXSTATx)  */
/************************************************************/
#define	ExColl		(1<<0)	//[0] Enable MAC Tx excessive collision
#define	Underflow	(1<<1)	//[1] Enable MAC Tx underflow
#define	DeferErr	(1<<2)	//[2] Enable MAC Tx deferral
#define	NoCarr		(1<<4)	//[4] Enable MAC Tx no carrier
#define	LateColl	(1<<5)	//[5] Enable MAC Tx late collision
#define	ParErr		(1<<6)	//[6] Enable MAC Tx transmit parity
#define	Comp		(1<<7)	//[7] Enable MAC Tx completion
#define	CFcomp		(1<<16)	//[16] Enable Tx complete to send control frame
#define	BTxNO		(1<<17)	//[17] BDMA Tx not owner interrupt enable
#define	BTxEmpty	(1<<18)	//[18] BDMA Tx buffer empty interrupt enable

/************************************************************/
/* BDMA/MAC Receive Interrupt Enable Register (BMRXINTENx)  */
/************************************************************/
#define	MissRollIE	(1<<0)	//[0] Enable MAC Tx excessive collision
#define	AlignErrIE	(1<<1)	//[1] Enable MAC Tx underflow
#define	CRCErrIE	(1<<2)	//[2] Enable MAC Tx deferral
#define	OverflowIE	(1<<3)	//[3] Enable MAC Tx no carrier
#define	LongErrIE	(1<<4)	//[4] Enable MAC Tx late collision
#define	RxParErrIE	(1<<5)	//[5] Enable MAC Tx transmit parity
#define	BRxDoneIE	(1<<16)	//[16] Enable MAC Tx completion
#define	BRxNOIE		(1<<17)	//[17] Enable Tx complete to send control frame
#define	BRxMSOIE	(1<<18)	//[18] BDMA Tx not owner interrupt enable
#define	BRxFullIE	(1<<19)	//[19] BDMA Tx buffer empty interrupt enable
#define	BRxEarlyIE	(1<<20)	//[20] BDMA Tx buffer empty interrupt enable

/************************************************************/
/* BDMA/MAC Receive Interrupt Status Register (BMRXSTATx)   */
/************************************************************/
#define	MissRoll	(1<<0)	//[0] BDMA Rx missed roll
#define	AlignErr	(1<<1)	//[1] BDMA Rx alignment error
#define	CRCErr		(1<<2)	//[2] BDMA Rx CRC error
#define	Overflow	(1<<3)	//[3] BDMA Rx overflow error
#define	LongErr		(1<<4)	//[4] BDMA Rx long error
#define	BRxParErr	(1<<5)	//[5] BDMA Rx parity error
#define	MRxDone		(1<<16)	//[16] BDMA Rx done
#define	BRxNO		(1<<17)	//[17] BDMA Rx not owner
#define	BRxMSO		(1<<18)	//[18] BDMA Rx max size over
#define	BRxFull		(1<<19)	//[19] BDMA Rx buffer full
#define	BRxEarly	(1<<20)	//[20] BDMA Rx early notify
#define	BRxFRF		(1<<21)	//[21] BDMA Rx one more frame in buffer
#define	BRxNFR		(0x1f<<22)	//[26:22] Number of frame in BDMA Rx buffer

/************************************************************/
/* BDMA Receive Frame Size Register (BDMARXLENx)            */
/************************************************************/
#define	BRxBS	(0xfff<<0)	//[11:0] BDAM Rx Buffer Size
#define	BRxMFS	(0xfff<<16)	//[27:16] BDMA Maximum Rx Frame Size

/************************************************************/
/* MAC Control Register (MACCONx)                           */
/************************************************************/
#define	MHaltReg	(1<<0)	//[0] Halt request
                                //    stop transmission and reception 
				//    after completion of ant current packets 
#define	MHaltImm	(1<<1)	//[1] Immediately stop all tranmit & reception
#define	MSwReset 	(1<<2) 	//[2] reset all MAC controller state machines and FIFOs 
#define	FullDup		(1<<3)	//[3] Full-duplex mode
#define	MLoopBack	(1<<4)	//[4] MAC loopback
#define	MIIOFF		(1<<6)	//[6] set to select 7-wire interface mode.
#define	MLoop10		(1<<7)	//[7] If this bit is set, Loop_10 external signal
                                //    is asserted to 10Mbps endec.
#define	MDCOFF		(1<<12)	//[12] MII Station Management Clock Off
#define	MLink10		(1<<15)	//[15] Link status 10Mbps 

/**********************************************************/
/* CAM control register(CAMCONx)                          */
/**********************************************************/
#define	MStation	(1<<0)	//[0] Accept any packet with a unicast address 
#define	MGroupAcc	(1<<1)	//[1] Accept any packet with multicast-group address  
#define	MBroadAcc	(1<<2)	//[2] Accept any packet with a broadcast address 
#define	MNegCAM		(1<<3)	//[3] 0: Accept packets CAM recognizes, reject others
				// 1: reject packets CAM recognizes, accept others 
#define	MCompEn		(1<<4)	//[4] Compare Enable mode

/**********************************************************/
/* Transmit Control Register(MACTXCONx)                   */
/**********************************************************/
#define	MTxEn		(1<<0)	// transmit Enable 
#define MTxHalt		(1<<1)	// Transmit Halt Request 
#define	MNoPad		(1<<2)	// suppress Padding 
#define	MNoCRC		(1<<3)	// Suppress CRC 
#define	MFBack		(1<<4)	// Fast Back-off
#define	MNoDef		(1<<5)	// Disable the defer counter
#define	MSdPause	(1<<6)	// Send Pause
#define	MSQEn		(1<<7)	// MII 10Mbps mode enable

/**********************************************************/
/* Receive Control Register (MACRXCONx)                   */
/**********************************************************/
#define	MRxEn		(1<<0)  // Enable MAC receive operation
#define	MRxHalt		(1<<1)  // Halt req. after packet receive complete 
#define	MLongEn		(1<<2)  // Enable receive long frame(>1518)
#define	MShortEn	(1<<3)  // Enable receive short frame(<64)
#define	MStripCRC	(1<<4)  // Check CRC & strip it from receive pkt.
#define	MPassCtl	(1<<5)  // Pass control packet
#define	MIgnoreCRC	(1<<6)  // No CRC

/**********************************************************/
/* MAC Transmit Status Register (MACTXSTATx)              */
/**********************************************************/
#define	MCollCnt	(15<<8)	//[11:8] count of collisions that occurred while TX frame
#define	MTxDefer	(1<<12)	//[12] Set Tx frame was deferred because of a delay
#define	MSQEErr		(1<<13)	//[13] Set Signal quality error
#define	MTxHalted	(1<<14)	//[14] Set if clear MTxEn or set MHaltImm bit
#define	MPaused		(1<<15)	//[15] Set Pause being received

/**********************************************************/
/* MAC Receive Status Register (MACRXSTATx)               */
/**********************************************************/
#define	MRxShort	(1<<8)	//[8] the frame was received with short frame
#define	MRx10Stat	(1<<9)	//[9] Set if frame was received over the 7-wire interface
#define	MRxHalted	(1<<10)	//[10] MRxEn bit is clear or MHaltImm bit is set
#define	MCtlRecd	(1<<11)	//[11] Control frame received

/**********************************************************/
/* Station Management control and address (STACONx)       */
/**********************************************************/
#define	MPHYRegAddr	(0x1f<<0)	//[4:0] PHY Register Address
#define	MPHYAddr	(0x1f<<5)	//[9:5] PHY Address
#define	MPHYWrite	(1<<10)	//[10] 0 : read operation, 1 : write operation
#define	MPHYBusy	(1<<11)	//[11] Set to start a read or write operation
#define	MPreSup		(1<<12)	//[12] Set if preamble is not sent to the PHY
#define	MMDCrate	(3<<13)	//[15:13] Control the MDC period
				// MDC period = (MMDCrate * 4) + 32

/**********************************************************/
/* CAM Enable (CAMENx)                                    */
/**********************************************************/
#define	CAMEn		(0x1fffff<<0)	//[20:0] 0 : disable, 1 : enable

/**********************************************************/
/* MAC Missed Error Count (MISSCNTx)                      */
/**********************************************************/
#define	MissErrCnt	(0xffff<<0)	//[15:0] Number of valid packets rejected by MAC

/*****************************************/
/* Tx,Rx Frame descriptor data structure */
/*****************************************/

/* Tx & Rx Frame Descriptor Ownership bit[31](O) */ 
#define	BDMA_owner	0x80000000 /* BDMA */
#define	CPU_owner	0x7fffffff /* CPU  */

/* Tx Frame Descriptor's control bits[6:0] */
/* [WA]: Widget alignment control */
#define	WidgetAlign00	(0<<16) /*       No Invalid bytes */
#define	WidgetAlign01	(1<<16) /*       1 Invalid byte   */
#define	WidgetAlign10	(2<<16) /*       2 Invalid bytes  */
#define	WidgetAlign11	(3<<16) /*       3 Invalid bytes  */
#define	TxLength 	(0x3fff<<0)	/* size of transmission data by using the BDMA */

/* Tx Frame descriptor's Status */
#define	TxExColl	(1<<18)	/* Excessive Collision */
#define	TxUnderflow	(1<<19)	/* MTxFIFO underflow */
#define	TxDeferErr	(1<<20)	/* Transmit deffered  */
#define	TxNoCarr	(1<<21)	/* No Carrier sense is detected when Tx */
#define	TxLateColl	(1<<22)	/* Collision occured after 64byte times */
#define	TxParErr	(1<<23)	/* MTxFIFO Parity Error */
#define	TxComp		(1<<24)	/* The transmition is finished */
#define	TxColl		(1<<25)	/* The collision is occured in half-duplex */
#define	Defer		(1<<26)	/* The transmition of frame was deferred */
#define	SQEErr		(1<<27)	/* Signal Qualith Error */
#define TxHalted	(1<<28)	/* Transmission was halted by clearing TxEn..*/
#define Paused		(1<<29)	/* Paused:holding data transmission DMA to MAC */

#define	RxLength 	0xffff	/* size of transmission data by using the BDMA */
/* Rx Frame descriptor's Status  */
#define	RxAlignErr	(1<<18)	/* Alignment Error*/
#define	RxCRCErr	(1<<19)	/* CRC error*/
#define	RxOverflow	(1<<20)	/* MAC receive FIFO was full when it*/ 
				/* needed to store a received byte*/
#define	MUFS		(1<<21)	/* received a frame longer than 1518bytes */
#define	RxParErr	(1<<22)	/* MAC receive FIFO has detected a parity error*/
#define BRxDone		(1<<23)	/* successfully received a packet with no errors*/
#define Rx10Stat	(1<<24)	/* set if packet was received via the */
				/* 10bits interface reset if packet */
				/* was received via MII*/
#define RxHalted	(1<<25)	/* Transmission was halted by clearing TxEn...*/
#define	RxMSO		(1<<26)	/* Rx frame size is larger then Maximum Rx Frame Size*/
#define	RxDone		(1<<27)	/* Set this bit to skip the current buffer descriptor */
				/* when the ownership bit is cleared */
#define	RxEOF		(1<<28)	/* Set by the BDMA to indicate the first BD for a frame */
#define	RxSOF		(1<<29)	/* Set by the BDMA to indicate the last BD for a frame */
#define	RxSkipBD	(1<<30)	/* Set by the BDMA on the first BD when the reception */
				/* of a frame finished and it used multiple BD's */

/*****************************************************/
/*      MAC Transmit Status Register(MACTXSTAT)      */
/*****************************************************/
#define MTxCollCnt	(15<<8)	//[11:8] Transmit collision count
#define MTxDefer	(1<<12)	//[12] MAC defers a transfer because of a delay
#define	MSQEErr		(1<<13)	//[13] Signal Quality Error
#define	MTxHalted	(1<<14)	//[14] Tx halted by clearing TxEn or set Haltimm bit. 
#define	MPaused		(1<<15)	//[15] packet was delayed due to a Pause being received. 

/*****************************************************/
/*      Receive Status Register(MACRXSTAT)           */
/*****************************************************/
#define	MRxShort	(1<<8)	//[8] the frame was received with short frame
#define	MRx10Stat	(1<<9)  //[9] Receive 10Mbps over 7-wire
#define	MRxHalted	(1<<10)	//[10] Reception halted by clearing MRxEn or
                                //    setting Haltimm bit in MAC control reg.
#define MCtlRecd	(1<<11)	//[11] Control frame received

/*****************************************************/
/*      Data Structure for BDMA Tx Error Count       */
/*****************************************************/
#define	S_BTxCCP	0x10000	 //[16] BDMA Tx Complete to send Control Packet 
#define	S_BTxNL		0x20000	 //[17] BDMA Tx Null List 
#define	S_BTxNO		0x40000	 //[18] BDMA Tx Not Owner
#define	S_BTxEmpty	0x100000 //[20] BDMA Tx Buffer Empty 

/* ------------------------------------------ */
/*   PHY(ICS1890) Register Description        */
/* ------------------------------------------ */
#define	PHY_CNTL_REG 	0x00
#define	PHY_STATUS_REG 	0x01
#define	PHY_ID_REG1    	0x02
#define	PHY_ID_REG2    	0x03
#define	PHY_ANA_REG    	0x04
#define	PHY_ANLPAR_REG 	0x05
#define	PHY_ANE_REG    	0x06
#define	PHY_ECNTL_REG1 	0x10
#define	PHY_QPDS_REG   	0x11
#define	PHY_10BOP_REG  	0x12
#define	PHY_ECNTL_REG2 	0x13
#define PHY_LED_CFG     0x14

#define PHYHWADDR	0x20	
#define PHYREGWRITE	0x1 << 10	
#define MiiBusy		0x1 << 11	

/* PHY control register */
#define RESET_PHY	1 << 15
#define ENABLE_LOOPBACK	1 << 14
#define DR_100MB	1 << 13
#define ENABLE_AN	1 << 12
#define PHY_MAC_ISOLATE	1 << 10
#define RESTART_AN	1 << 9
#define PHY_FULLDUPLEX	1 << 8
#define PHY_COL_TEST	1 << 7

/* PHY Status register */
#define LINK_UP 	1 << 2
#define AN_COMPLETE	1 << 5

/* PHY Auto-negotiation Advertisement register */
#define DR100_TX_FULL	1 << 8
#define DR100_TX_HALF	1 << 7
#define DR10_TX_FULL	1 << 6
#define DR10_TX_HALF	1 << 5

/* ----------------------- *
 * Prototype Definition    *
 * ----------------------- */
#define MaxRxFrameSize	(1520)

#define TX_FRAME_SIZE	(1<<BTxNBD)	/* Max number of MAC Tx frame */
#define RX_FRAME_SIZE	(1<<BRxNBD)	/* Max number of MAC Rx frame */

struct frame_desc_struct {
	unsigned long  FB_ptr;   /* frame data pointer */
	unsigned long  info;     /* status and frame length */
};

struct frame_buf_struct {
	unsigned char dst[ETH_ALEN];
	unsigned char src[ETH_ALEN];
	unsigned short proto;
	unsigned char data[ETH_DATA_LEN + 22];
};

enum {
	gMACCON = FullDup,
	gMACTXCON = MTxEn,
	gMACRXCON = MRxEn,
	gBDMATXCON = BTxMSL110 | BTxNBD,
	gBDMARXCON = BRxEn | BRxWA10 | BRxNBD,
	gCAMCON = MCompEn | MBroadAcc
};

#endif /* __MAC_H */
