#ifndef	_W5300_H_
#define	_W5300_H_

#include "types.h"

/*********************************************************
* iinchip access function
*********************************************************/
/**
 * \brief Basic I/O function
 *        
 */
//#ifdef (__DEF_IINCHIP_BUS__ == __DEF_IINCHIP_DIRECT_MODE__)
//#define  IINCHIP_READ(uint32 addr)         (*((vuint16*)addr))
//#define  IINCHIP_WRITE(uint32 addr, data)  (*((vuint16*)addr) = data)
//#else
//   uint16   IINCHIP_READ(uint32 addr);
//   void     IINCHIP_WRITE(uint32 addr,uint16 data);
//#endif




void     iinchip_init(void); // reset iinchip

uint8    sysinit(uint8* tx_size, uint8* rx_size); // setting tx/rx buf size

#ifdef __DEF_IINCHIP_INT__
   void     iinchip_irq(void);
#endif


#ifdef __DEF_IINCHIP_PPP__
   uint8    pppinit(uint8 *id, uint8 idlen, uint8 *passwd, uint8 passwdlen);
   uint8    pppterm(uint8 *mac,uint8 *sessionid);
#endif

uint32   getIINCHIP_TxMAX(SOCKET s);
uint32   getIINCHIP_RxMAX(SOCKET s);

/**
 * \brief   COMMON Register Access Function.
 *
 */
uint16   getMR(void);
void     setMR(uint16 val);

uint16   getIR(uint8 s);
void     setIR(uint16 val);

uint16   getIMR(void);
void     setIMR(uint16 mask); // set interrupt mask. 

uint16   getICFGR(void);
void     setICFGR(uint16 icfg);


void     getSHAR(uint8 * addr);
void     setSHAR(uint8 * addr);   // set local MAC address

void     getGAR(uint8 * addr);
void     setGAR(uint8 * addr);    // set gateway address

void     getSUBR(uint8 * addr);
void     setSUBR(uint8 * addr); // set subnet mask address

void     getSIPR(uint8 * addr);
void     setSIPR(uint8 * addr); // set local IP address

uint16   getRTR(void); 
void     setRTR(uint16 timeout); // set retry duration for data transmission, connection, closing ...


uint8    getRCR(void);
void     setRCR(uint8 retry); // set retry count (above the value, assert timeout interrupt)


uint16   getPATR(void);

uint8    getPTIMER(void);
void     setPTIMER(uint8 time);

uint8    getPMAGICR(void);
void     setPMAGICR(uint8 magic);

uint16   getPSIDR(void);

void     getPDHAR(uint8* addr);

void     getUIPR(uint8* addr);

uint16   getUPORTR(void);

uint16   getFMTUR(void);

uint8    getPn_BRDYR(uint8 p);
void     setPn_BRDYR(uint8 p, uint8 cfg);


uint16   getPn_BDPTHR(uint8 p);
void     setPn_BDPTHR(uint8 p, uint16 depth);


uint16   getIDR(void);


/**
 * \brief SOCKET Register Access Function.
 *
 */
uint16   getSn_MR(SOCKET s);
void     setSn_MR(SOCKET s, uint16 mode); 

uint8    getSn_CR(SOCKET s);
void     setSn_CR(SOCKET s, uint16 com);

uint8    getSn_IMR(SOCKET s);
void     setSn_IMR(SOCKET s, uint8 mask);

uint8    getSn_IR(SOCKET s);
void     setSn_IR(SOCKET s, uint8 ir);

uint8    getSn_SSR(SOCKET s);

void     getSn_DHAR(SOCKET s, uint8* addr);
void     setSn_DHAR(SOCKET s, uint8* addr);

uint16   getSn_DPORTR(SOCKET s);
void     setSn_DPORTR(SOCKET s, uint16 port);

void     getSn_DIPR(SOCKET s, uint8* addr);
void     setSn_DIPR(SOCKET s, uint8* addr);


uint16   getSn_MSSR(SOCKET s);
void     setSn_MSSR(SOCKET s, uint16 mss);

uint8    getSn_KPALVTR(SOCKET s);
void     setSn_KPALVTR(SOCKET s, uint8 time);


uint8    getSn_PROTOR(SOCKET s);
void     setSn_PROTOR(SOCKET s, uint8 pronum);

uint8    getSn_TOSR(SOCKET s);
void     setSn_TOSR(SOCKET s, uint8 tos);

uint8    getSn_TTLR(SOCKET s);
void     setSn_TTLR(SOCKET s, uint8 ttl);

uint32   getSn_TX_WRSR(SOCKET s);
void     setSn_TX_WRSR(SOCKET s, uint32 size);

uint32   getSn_TX_FSR(SOCKET s);

uint32   getSn_RX_RSR(SOCKET s);

uint8    getSn_FRAGR(SOCKET s);
void     setSn_FRAGR(SOCKET s, uint8 frag);

void     setSn_TX_FIFOR(SOCKET s, uint16 data);

uint16   getSn_RX_FIFOR(SOCKET s);

#endif
