/*
 * (c)COPYRIGHT
 * ALL RIGHT RESERVED
 *
 * FileName : w5300.c
 * Revision History :
 * ----------  -------  -----------  ------------------------------------------------
 * Date        version  Name         Description
 * ----------  -------  -----------  ------------------------------------------------
 * 03/10/2008  1.0.1    W            support basic op in W5300
 *                                   only support direct mode, do not support PPPoE
 * ----------------------------------------------------------------------------------
 *
 * last update : MAR 10, 2008
 */
#include "w5300.h"
#include <w5300_mac.h>

uint32 TXMEM_SIZE[W5300_MAX_CHANNEL] = W5300_TMSR_ARRAY;
uint32 RXMEM_SIZE[W5300_MAX_CHANNEL] = W5300_RMSR_ARRAY;

uint8 SOCK_INT[W5300_MAX_CHANNEL];

/*********************************************************
* iinchip access function
*********************************************************/

#ifdef __DEF_IINCHIP_INT__
void     iinchip_irq(void)
{
	uint16 int_val;
	uint16 idx;
	IINCHIP_ISR_DISABLE();
	int_val = IINCHIP_READ(IR);          

	if (int_val & (IR_CONFLICT << 8))
	{
		printf("IP conflict : %04x\r\n", int_val);
	}
	if (int_val & (IR_UNREACH << 8))
	{
		printf("INT Port Unreachable : %04x\r\n", int_val);
		printf("UIPR : %d.%d.%d.%d\r\n", (uint8)(IINCHIP_READ(UIPR)>>8),
		                                 (uint8)IINCHIP_READ(UIPR),
		                                 (uint8)(IINCHIP_READ(UIPR2)>>8),
		                                 (uint8)IINCHIP_READ(UIPR2));
		printf("UPORT : %04x\r\n", IINCHIP_READ(UPORT));
	}

   for(idx = 0 ; idx < W5300_MAX_CHANNEL; idx++)
   {
   	if (int_val & IR_SOCK(idx))
   	{
   		SOCK_INT[idx] = (uint8)IINCHIP_READ(Sn_IR(idx));
      	IINCHIP_WRITE(Sn_IR(idx),(uint16)SOCK_INT[idx]);
   	}
   }

	IINCHIP_WRITE(IR, int_val & 0xFF00);
	IINCHIP_ISR_ENABLE();
}
#endif


#ifdef __DEF_IINCHIP_PPP__

#define PPP_OPTION_BUF_LEN 64

uint8    pppinit_in(uint8 * id, uint8 idlen, uint8 * passwd, uint8 passwdlen)
{
   // under developing
   return 0;
}

uint8    pppinit(uint8 *id, uint8 idlen, uint8 *passwd, uint8 passwdlen)
{
   // under developing
   return 0;
}
   
uint8    pppterm(uint8 *mac,uint8 *sessionid)
{
   // under developing
   return 0;
}
#endif

uint32   getIINCHIP_TxMAX(SOCKET s)
{
   return TXMEM_SIZE[s] << 10;
}

uint32   getIINCHIP_RxMAX(SOCKET s)
{
   return RXMEM_SIZE[s] << 10;
}

/**
 * \brief   COMMON Register Access Function.
 *
 */
uint16   getMR(void)
{
   return *((vint16*)MR);
}
void     setMR(uint16 val)
{
   *((vint16*)MR) = val;   
}

uint16   getIR(uint8 s)
{
   return IINCHIP_READ(IR);
}
void     setIR(uint16 val)
{
   IINCHIP_WRITE(IR, val);   
}

uint16   getIMR(void)
{
   return IINCHIP_READ(IMR);
}
void     setIMR(uint16 mask)
{
   IINCHIP_WRITE(IMR, mask);
}


uint16   getICFGR(void)
{
   return IINCHIP_READ(ICFGR);   
}
void     setICFGR(uint16 icfg)
{
   IINCHIP_WRITE(ICFGR, icfg);   
}


void     getSHAR(uint8 * addr)
{
  	addr[0] = (uint8)(IINCHIP_READ(SHAR)>>8);
	addr[1] = (uint8)IINCHIP_READ(SHAR);
	addr[2] = (uint8)(IINCHIP_READ(SHAR2)>>8);
	addr[3] = (uint8)IINCHIP_READ(SHAR2);
	addr[4] = (uint8)(IINCHIP_READ(SHAR4)>>8);
	addr[5] = (uint8)IINCHIP_READ(SHAR4);
}
void     setSHAR(uint8 * addr)
{
	IINCHIP_WRITE(SHAR,(((uint16)addr[0])<<8)+addr[1]);
   IINCHIP_WRITE(SHAR2,((uint16)addr[2]<<8)+addr[3]);
	IINCHIP_WRITE(SHAR4,((uint16)addr[4]<<8)+addr[5]);
}

void     getGAR(uint8 * addr)
{
	addr[0] = (uint8)(IINCHIP_READ(GAR)>>8);
	addr[1] = (uint8)IINCHIP_READ(GAR);
	addr[2] = (uint8)(IINCHIP_READ(GAR2)>>8);
	addr[3] = (uint8)IINCHIP_READ(GAR2);   
}
void     setGAR(uint8 * addr)
{
	IINCHIP_WRITE(GAR, ((uint16)addr[0]<<8)+(uint16)addr[1]);
	IINCHIP_WRITE(GAR2,((uint16)addr[2]<<8)+(uint16)addr[3]);   
}

void     getSUBR(uint8 * addr)
{
	addr[0] = (uint8)(IINCHIP_READ(SUBR)>>8);
	addr[1] = (uint8)IINCHIP_READ(SUBR);
	addr[2] = (uint8)(IINCHIP_READ(SUBR2)>>8);
	addr[3] = (uint8)IINCHIP_READ(SUBR2);   
}
void     setSUBR(uint8 * addr)
{
	IINCHIP_WRITE(SUBR, ((uint16)addr[0]<<8)+(uint16)addr[1]);
	IINCHIP_WRITE(SUBR2,((uint16)addr[2]<<8)+(uint16)addr[3]);   
}

void     getSIPR(uint8 * addr)
{
	addr[0] = (uint8)(IINCHIP_READ(SIPR)>>8);
	addr[1] = (uint8)IINCHIP_READ(SIPR);
	addr[2] = (uint8)(IINCHIP_READ(SIPR2)>>8);
	addr[3] = (uint8)IINCHIP_READ(SIPR2);	
}
void     setSIPR(uint8 * addr)
{
	IINCHIP_WRITE(SIPR,((uint16)addr[0]<<8)+(uint16)addr[1]);
	IINCHIP_WRITE(SIPR2,((uint16)addr[2]<<8)+(uint16)addr[3]);   
}

uint16   getRTR(void)
{
   return IINCHIP_READ(RTR);
}
void     setRTR(uint16 timeout)
{
	IINCHIP_WRITE(RTR,timeout);   
}


uint8    getRCR(void)
{
   return (uint8)IINCHIP_READ(RCR);
}
void     setRCR(uint8 retry)
{
   IINCHIP_WRITE(RCR,retry);
}


uint16   getPATR(void)
{
   return IINCHIP_READ(PATR);
}

uint8    getPTIMER(void)
{
   return (uint8)IINCHIP_READ(PTIMER);
}
void     setPTIMER(uint8 time)
{
   IINCHIP_WRITE(PTIMER,time);
}

uint8    getPMAGICR(void)
{
   return (uint8)IINCHIP_READ(PMAGICR);
}
void     setPMAGICR(uint8 magic)
{
   IINCHIP_WRITE(PMAGICR,magic);
}

uint16   getPSIDR(void)
{
   return IINCHIP_READ(PSIDR);
}

void     getPDHAR(uint8* addr)
{
   addr[0] = (uint8)(IINCHIP_READ(PDHAR) >> 8);
   addr[1] = (uint8)IINCHIP_READ(PDHAR);
   addr[2] = (uint8)(IINCHIP_READ(PDHAR2) >> 8);
   addr[3] = (uint8)IINCHIP_READ(PDHAR2);
   addr[4] = (uint8)(IINCHIP_READ(PDHAR4) >> 8);
   addr[5] = (uint8)IINCHIP_READ(PDHAR4);
}

void     getUIPR(uint8* addr)
{
   addr[0] = (uint8)(IINCHIP_READ(UIPR) >> 8);
   addr[1] = (uint8)IINCHIP_READ(UIPR);
   addr[2] = (uint8)(IINCHIP_READ(UIPR2) >> 8);
   addr[3] = (uint8)IINCHIP_READ(UIPR2);   
}

uint16   getUPORTR(void)
{
   return IINCHIP_READ(UPORTR);
}

uint16   getFMTUR(void)
{
   return IINCHIP_READ(FMTUR);
}

uint8    getPn_BRDYR(uint8 p)
{
   return (uint8)IINCHIP_READ(Pn_BRDYR(p));
}
void     setPn_BRDYR(uint8 p, uint8 cfg)
{
   IINCHIP_WRITE(Pn_BRDYR(p),cfg);   
}


uint16   getPn_BDPTHR(uint8 p)
{
   return IINCHIP_READ(Pn_BDPTHR(p));   
}
void     setPn_BDPTHR(uint8 p, uint16 depth)
{
   IINCHIP_WRITE(Pn_BDPTHR(p),depth);
}


uint16   getIDR(void)
{
   return IINCHIP_READ(IDR);
}


/**
 * \brief SOCKET Register Access Function.
 *
 */
uint16   getSn_MR(SOCKET s)
{
   return IINCHIP_READ(Sn_MR(s));
}
void     setSn_MR(SOCKET s, uint16 mode)
{
   IINCHIP_WRITE(Sn_MR(s),mode);
}

uint8    getSn_CR(SOCKET s)
{
   return IINCHIP_READ(Sn_CR(s));
}
void     setSn_CR(SOCKET s, uint16 com)
{
   IINCHIP_WRITE(Sn_CR(s),com);
}

uint8    getSn_IMR(SOCKET s)
{
   return (uint8)IINCHIP_READ(Sn_IMR(s));
}
void     setSn_IMR(SOCKET s, uint8 mask)
{
   IINCHIP_WRITE(Sn_IMR(s),mask);
}

uint8    getSn_IR(SOCKET s)
{
   #ifdef __DEF_IINCHIP_INT__
      return SOCK_INT[s];
   #else      
      return (uint8)IINCHIP_READ(Sn_IR(s));
   #endif   
}
void     setSn_IR(SOCKET s, uint8 ir)
{
   #ifdef __DEF_IINCHIP_INT__
      SOCK_INT[s] = SOCK_INT[s] & ~(ir);
   #else
      IINCHIP_WRITE(Sn_IR(s),ir);
   #endif   
}

uint8    getSn_SSR(SOCKET s)
{
   uint8 ssr, ssr1;
   ssr = (uint8)IINCHIP_READ(Sn_SSR(s));
#if __DEF_IINCHIP_REG_READ__ > 0  
   while(1)
   {
      ssr1 = (uint8)IINCHIP_READ(Sn_SSR(s));
      if(ssr == ssr1) break;
      ssr = ssr1;
   }
#endif   
   return ssr;
}

void     getSn_DHAR(SOCKET s, uint8* addr)
{
   addr[0] = (uint8)(IINCHIP_READ(Sn_DHAR(s))>>8);
   addr[1] = (uint8)IINCHIP_READ(Sn_DHAR(s));
   addr[2] = (uint8)(IINCHIP_READ(Sn_DHAR2(s))>>8);
   addr[3] = (uint8)IINCHIP_READ(Sn_DHAR2(s));
   addr[4] = (uint8)(IINCHIP_READ(Sn_DHAR4(s))>>8);
   addr[5] = (uint8)IINCHIP_READ(Sn_DHAR4(s));
}
void     setSn_DHAR(SOCKET s, uint8* addr)
{
   IINCHIP_WRITE(Sn_DHAR(s),  ((uint16)(addr[0]<<8)) + addr[1]);
   IINCHIP_WRITE(Sn_DHAR2(s), ((uint16)(addr[2]<<8)) + addr[3]);
   IINCHIP_WRITE(Sn_DHAR4(s), ((uint16)(addr[4]<<8)) + addr[5]);
}

uint16   getSn_DPORTR(SOCKET s)
{
   return IINCHIP_READ(Sn_DPORTR(s));
}
void     setSn_DPORTR(SOCKET s, uint16 port)
{
   IINCHIP_WRITE(Sn_DPORTR(s),port);
}

void     getSn_DIPR(SOCKET s, uint8* addr)
{
   addr[0] = (uint8)(IINCHIP_READ(Sn_DIPR(s))>>8);
   addr[1] = (uint8)IINCHIP_READ(Sn_DIPR(s));
   addr[2] = (uint8)(IINCHIP_READ(Sn_DIPR2(s))>>8);
   addr[3] = (uint8)IINCHIP_READ(Sn_DHAR2(s));   
}
void     setSn_DIPR(SOCKET s, uint8* addr)
{
   IINCHIP_WRITE(Sn_DIPR(s),  ((uint16)(addr[0]<<8)) + addr[1]);
   IINCHIP_WRITE(Sn_DIPR2(s), ((uint16)(addr[2]<<8)) + addr[3]);  
}

uint16   getSn_MSSR(SOCKET s)
{
   return IINCHIP_READ(Sn_MSSR(s));
}
void     setSn_MSSR(SOCKET s, uint16 mss)
{
   IINCHIP_WRITE(Sn_MSSR(s),mss);
}

uint8    getSn_KPALVTR(SOCKET s)
{
   return (uint8)(IINCHIP_READ(Sn_KPALVTR(s)) >> 8);
}
void     setSn_KPALVTR(SOCKET s, uint8 time)
{
   uint16 keepalive=0;
   keepalive = (IINCHIP_READ(Sn_KPALVTR(s)) & 0x00FF) + ((uint16)time<<8);
   IINCHIP_WRITE(Sn_KPALVTR(s),keepalive);
}


uint8    getSn_PROTOR(SOCKET s)
{
   return (uint8)IINCHIP_READ(Sn_PROTOR(s));
}
void     setSn_PROTOR(SOCKET s, uint8 pronum)
{
   uint16 protocolnum;
   protocolnum = IINCHIP_READ(Sn_PROTOR(s)) & 0xFF00 + pronum;
   IINCHIP_WRITE(Sn_PROTOR(s),protocolnum);
}

uint8    getSn_TOSR(SOCKET s)
{
   return (uint8)IINCHIP_READ(Sn_TOSR(s));
}
void     setSn_TOSR(SOCKET s, uint8 tos)
{
   IINCHIP_WRITE(Sn_TOSR(s),tos);
}

uint8    getSn_TTLR(SOCKET s)
{
   return (uint8)IINCHIP_READ(Sn_TTLR(s));
}
void     setSn_TTLR(SOCKET s, uint8 ttl)
{
   IINCHIP_WRITE(Sn_TTLR(s),ttl);
}

uint32   getSn_TX_WRSR(SOCKET s)
{
   uint32 tx_write_size=0;
   tx_write_size = IINCHIP_READ(Sn_TX_WRSR(s));
   tx_write_size = (tx_write_size << 16) + IINCHIP_READ(Sn_TX_WRSR2(s));
   return tx_write_size;
}
void     setSn_TX_WRSR(SOCKET s, uint32 size)
{
   IINCHIP_WRITE(Sn_TX_WRSR(s), (uint16)(size >> 16));
   IINCHIP_WRITE(Sn_TX_WRSR2(s), (uint16)size);
}

uint32   getSn_TX_FSR(SOCKET s)
{
   uint32 free_tx_size=0;

   free_tx_size = IINCHIP_READ(Sn_TX_FSR(s));
   free_tx_size = (free_tx_size << 16) + IINCHIP_READ(Sn_TX_FSR2(s));

   return free_tx_size;
}

uint32   getSn_RX_RSR(SOCKET s)
{
   uint32 received_rx_size=0;
   received_rx_size = IINCHIP_READ(Sn_RX_RSR(s));
   received_rx_size = (received_rx_size << 16) + IINCHIP_READ(Sn_RX_RSR2(s));
   return received_rx_size;   
}

uint8    getSn_FRAGR(SOCKET s)
{
   return (uint8)IINCHIP_READ(Sn_FRAGR(s));
}
void     setSn_FRAGR(SOCKET s, uint8 frag)
{
   IINCHIP_WRITE(Sn_FRAGR(s),frag);
}

void     setSn_TX_FIFOR(SOCKET s, uint16 data)
{
   IINCHIP_WRITE(Sn_TX_FIFOR(s),data);
}

uint16   getSn_RX_FIFOR(SOCKET s)
{
   return IINCHIP_READ(Sn_RX_FIFOR(s));
}
