#ifndef	_SOCKET_H_
#define	_SOCKET_H_

#include "types.h"

/**********************************************************
*
* define function of socket API 
*
***********************************************************/
uint8    socket(SOCKET s, uint8 protocol, uint16 port, uint16 flag);                // Opens a socket(TCP or UDP or IP_RAW mode)
void     close(SOCKET s);                                                           // Close socket
uint8    connect(SOCKET s, uint8 * addr, uint16 port);                              // Establish TCP connection (Active connection)
void     disconnect(SOCKET s);                                                      // disconnect the connection
uint8    listen(SOCKET s);	                                                         // Establish TCP connection (Passive connection)
uint32   send(SOCKET s, uint16 * buf, uint32 len);                                  // Send data (TCP)
uint32   recv(SOCKET s, uint16 * buf, uint32 len);	                                 // Receive data (TCP)
uint32   sendto(SOCKET s, uint16 * buf, uint32 len, uint8 * addr, uint16 port);     // Send data (UDP/IP RAW)
uint32   recvfrom(SOCKET s, uint16 * buf, uint32 len, uint8 * addr, uint16  *port); // Receive data (UDP/IP RAW)
#endif
/* _SOCKET_H_ */
