/*
 * (c)COPYRIGHT
 * ALL RIGHT RESERVED
 *
 * FileName : socket.c
 * Revision History :
 * ----------  -------  -----------  ------------------------------------------------
 * Date        version  Name         Description
 * ----------  -------  -----------  ------------------------------------------------
 * 03/10/2008  1.0.1    W            support basic op in W5300
 *                                   only support direct mode, do not support PPPoE
 * ----------------------------------------------------------------------------------
 *
 * last update : MAR 10, 2008
 */

#include <common.h>
#include "socket.h"
#include "w5300.h"
#include <w5300_mac.h>

uint16   iinchip_source_port;
uint8    check_sendok_flag[W5300_MAX_CHANNEL];

/**
* Internal Functions
*/
static void   wiz_write_buf(SOCKET s,uint16* buf,uint32 len)
{
	uint32 idx=0;
	for (idx = (len >> 1); idx > 0; idx--) IINCHIP_WRITE(Sn_TX_FIFOR(s),*buf++);
}

static void   wiz_read_buf(SOCKET s, uint16* buf,uint32 len)
{
	uint32 idx;
	for (idx = (len >> 1); idx > 0; idx--) *buf++ = IINCHIP_READ(Sn_RX_FIFOR(s));
}

uint8    socket(SOCKET s, uint8 protocol, uint16 port, uint16 flag)
{
	uint8 ret;
	IINCHIP_WRITE(Sn_MR(s),(uint16)(protocol | flag));
	if (port != 0) IINCHIP_WRITE(Sn_PORTR(s),port);
   else 
   {
      iinchip_source_port++; // if don't set the source port, set local_port number.
      IINCHIP_WRITE(Sn_PORTR(s),iinchip_source_port);
   }
   IINCHIP_WRITE(Sn_CR(s),Sn_CR_OPEN); // run sockinit Sn_CR
   while((uint8)IINCHIP_READ(Sn_CR(s)));

	check_sendok_flag[s] = 1;
	return 1;   
}

void     close(SOCKET s)
{
	IINCHIP_WRITE(Sn_CR(s),Sn_CR_CLOSE);
	while((uint8)IINCHIP_READ(Sn_CR(s)));
}

uint8    connect(SOCKET s, uint8 * addr, uint16 port)
{
	if 
		(
			((addr[0] == 0xFF) && (addr[1] == 0xFF) && (addr[2] == 0xFF) && (addr[3] == 0xFF)) ||
		 	((addr[0] == 0x00) && (addr[1] == 0x00) && (addr[2] == 0x00) && (addr[3] == 0x00)) ||
		 	(port == 0x00) 
		)
 	{
//   #ifdef __DEF_IINCHIP_DBG__
//	   printf("%d : Fail[invalid ip,port]\r\n",s);
//   #endif
      return 0;
	}

	// set destination IP
	IINCHIP_WRITE(Sn_DIPR(s),((uint16)addr[0]<<8)+(uint16)addr[1]);
	IINCHIP_WRITE(Sn_DIPR2(s),((uint16)addr[2]<<8)+(uint16)addr[3]);
	IINCHIP_WRITE(Sn_DPORTR(s),port);

	IINCHIP_WRITE(Sn_CR(s),(uint16)Sn_CR_CONNECT);
	// wait for completion
	while (IINCHIP_READ(Sn_CR(s))) ;
	return 1;
}

void     disconnect(SOCKET s)
{
	IINCHIP_WRITE(Sn_CR(s),Sn_CR_DISCON);
	while (IINCHIP_READ(Sn_CR(s)));
}

uint8    listen(SOCKET s)
{
	uint8 ret;
	if (getSn_SSR(s) != SOCK_INIT)
	{
//   #ifdef __DEF_IINCHIP_DBG__
//	   printf("%d : SOCKET is not created!\r\n",s);
//   #endif
	   return 0;
   }
   IINCHIP_WRITE(Sn_CR(s),Sn_CR_LISTEN);
	while (IINCHIP_READ(Sn_CR(s)));
	while(getSn_SSR(s) != SOCK_LISTEN)
	{
		if ((uint8)IINCHIP_READ(Sn_SSR(s)) == SOCK_CLOSED)
		{
//      #ifdef __DEF_IINCHIP_DBG__
//   		printf("%d : Listen Fail. SOCK_CLOSED.\r\n",s);
//      #endif
			return 0;
		}
	}
	return 1;
}  
 
uint32   send(SOCKET s, uint16 * buf, uint32 len)
{
	uint16 status;
	uint32 ret;
	uint32 freesize;
   uint32 loopcnt;

   ret = len;
   if (len > getIINCHIP_TxMAX(s)) ret = getIINCHIP_TxMAX(s); // check size not to exceed MAX size.

   loopcnt=0; 
   do
   {
   	freesize = getSn_TX_FSR(s);
   	status = getSn_SSR(s);
//      #ifdef __DEF_IINCHIP_DBG__
//		   printf("%d : freesize=%ld\r\n",s,freesize);
//      #endif
		if ((status != SOCK_ESTABLISHED) && (status != SOCK_CLOSE_WAIT)) return 0;
   } while (freesize < ret);

   // copy data
   if(ret&0x01) wiz_write_buf(s,buf,ret+1);
   else wiz_write_buf(s,buf,ret);

   loopcnt=0;
   if(!check_sendok_flag[s])
   {
      while (!(getSn_IR(s) & Sn_IR_SEND_OK))
    	{
         status = getSn_SSR(s);
         if ((uint8)status == SOCK_CLOSED)
         {
//         #ifdef __DEF_IINCHIP_DBG__
//   			printf("%d : Send Fail. SOCK_CLOSED.\r\n",s);
//         #endif
         	return 0;
         }
      }
      setSn_IR(s, Sn_IR_SEND_OK);
   }
   else check_sendok_flag[s] = 0;
   
   setSn_TX_WRSR(s,ret);   
   IINCHIP_WRITE(Sn_CR(s),Sn_CR_SEND);
   while(IINCHIP_READ(Sn_CR(s)));

   return ret;
}

uint32   recv(SOCKET s, uint16 * buf, uint32 len)
{
	uint16 pack_size=0;
	uint16 mr=0;

   if(IINCHIP_READ(Sn_MR(s)) & Sn_MR_ALIGN)
   {
    	wiz_read_buf(s, buf, (uint32)len);
   	IINCHIP_WRITE(Sn_CR(s),Sn_CR_RECV);
      while(IINCHIP_READ(Sn_CR(s)));
   	return len;
   }
   
   wiz_read_buf(s,&pack_size,2);
   if( (*(vint16*)MR) & MR_FIFOSWAP )
      pack_size = ((((pack_size << 8 ) & 0xFF00)) | ((pack_size >> 8)& 0x00FF));

   len = (uint32)pack_size;
   if(pack_size&0x01) len+=1;
   
//   #ifdef __DEF_IINCHIP_DBG__   
//      printf("%d:pack_size=%d\r\n",s,pack_size);
//   #endif
	wiz_read_buf(s, buf, len);

	IINCHIP_WRITE(Sn_CR(s),Sn_CR_RECV);
   while(IINCHIP_READ(Sn_CR(s)));
	return (uint32)pack_size;
}

uint32   sendto(SOCKET s, uint16 * buf, uint32 len, uint8 * addr, uint16 port)
{
	uint8 status=0;
	uint8 isr=0;
	uint32 ret=0;
	
//   #ifdef __DEF_IINCHIP_DBG__
//	   printf("%d : sendto():%d.%d.%d.%d(%d), len=%d\r\n",s, addr[0], addr[1], addr[2], addr[3] , port, len);
//   #endif

	if
		(
		 	((addr[0] == 0x00) && (addr[1] == 0x00) && (addr[2] == 0x00) && (addr[3] == 0x00)) ||
		 	((port == 0x00)) ||(len == 0)
		) 
 	{
//   #ifdef __DEF_IINCHIP_DBG__
//	   printf("%d : Fail[%d.%d.%d.%d, %.d, %d]\r\n",s, addr[0], addr[1], addr[2], addr[3] , port, len);
//   #endif
      return 0;
	}


   if (len > getIINCHIP_TxMAX(s)) ret = getIINCHIP_TxMAX(s); // check size not to exceed MAX size.
   else ret = len;

	IINCHIP_WRITE(Sn_DIPR(s),(((uint16)addr[0])<<8) + (uint16) addr[1]);
	IINCHIP_WRITE(Sn_DIPR2(s),(((uint16)addr[2])<<8) + (uint16) addr[3]);
	IINCHIP_WRITE(Sn_DPORTR(s),port);

   // copy data
   wiz_write_buf(s, buf, ret+(ret & 0x01));      
   setSn_TX_WRSR(s,ret);
	IINCHIP_WRITE(Sn_CR(s),Sn_CR_SEND);
   while (!((isr = getSn_IR(s)) & Sn_IR_SEND_OK))
	{
   	status = getSn_SSR(s);

		if ((status == SOCK_CLOSED) || (isr & Sn_IR_TIMEOUT))
		{
      #ifdef __DEF_IINCHIP_DBG__
		   printf("%d: send fail.status=0x%02x,isr=%02x\r\n",status,isr);
      #endif
         printf("%d : Sn_TX_RD=%04x,Sn_TX_WR=%04x\r\n",s,IINCHIP_READ(Sn_TX_RD(s)),IINCHIP_READ(Sn_TX_WR(s)));	   			
         setSn_IR(s,Sn_IR_TIMEOUT);
			return 0;
		}
	}
	setSn_IR(s, Sn_IR_SEND_OK);
		
//   #ifdef __DEF_IINCHIP_DBG__		
//      printf("%d : send()end\r\n",s);
//   #endif       

	return ret;   
}

uint32   recvfrom(SOCKET s, uint16 * buf, uint32 len, uint8 * addr, uint16  *port)
{
	uint16 head[4];
	uint32 data_len=0;
	uint16 crc[2];

	if ( len > 0 )
	{
   	switch (IINCHIP_READ(Sn_MR(s)) & 0x07)
   	{
   	case Sn_MR_UDP :
   			wiz_read_buf(s, head, 8);
   			// read peer's IP address, port number.
   			if(*((vuint16*)MR) & MR_FIFOSWAP)
   			{
   			   head[0] = ((((head[0] << 8 ) & 0xFF00)) | ((head[0] >> 8)& 0x00FF));
   			   head[1] = ((((head[1] << 8 ) & 0xFF00)) | ((head[1] >> 8)& 0x00FF));
   			   head[2] = ((((head[2] << 8 ) & 0xFF00)) | ((head[2] >> 8)& 0x00FF));
   			   head[3] = ((((head[3] << 8 ) & 0xFF00)) | ((head[3] >> 8)& 0x00FF));
   			}
    			addr[0] = (uint8)(head[0] >> 8);
   			addr[1] = (uint8)head[0];
   			addr[2] = (uint8)(head[1]>>8);
   			addr[3] = (uint8)head[1];
   			*port = head[2];
   			data_len = (uint32)head[3];
   			
//            #ifdef __DEF_IINCHIP_DBG__
//      			printf("UDP msg arrived:%d(0x%04x)\r\n",data_len,data_len);
//      			printf("source Port : %d\r\n", *port);
//      			printf("source IP : %d.%d.%d.%d\r\n", addr[0], addr[1], addr[2], addr[3]);
//            #endif
      		wiz_read_buf(s, buf, data_len+(data_len & 0x01)); // data copy.
   			break;
   
   	case Sn_MR_IPRAW :
   			wiz_read_buf(s, (uint16*)head, 6);
   			if(*((vuint16*)MR) & MR_FIFOSWAP)
   			{
   			   head[0] = ((((head[0] << 8 ) & 0xFF00)) | ((head[0] >> 8)& 0x00FF));
   			   head[1] = ((((head[1] << 8 ) & 0xFF00)) | ((head[1] >> 8)& 0x00FF));
   			   head[2] = ((((head[2] << 8 ) & 0xFF00)) | ((head[2] >> 8)& 0x00FF));
   			}   			
     			addr[0] = (uint8)(head[0] >> 8);
   			addr[1] = (uint8)head[0];
   			addr[2] = (uint8)(head[1]>>8);
   			addr[3] = (uint8)head[1];
            data_len = (uint32)head[2];
   	
//            #ifdef __DEF_IINCHIP_DBG__
//      			printf("IP RAW msg arrived\r\n");
//      			printf("source IP : %d.%d.%d.%d\r\n", addr[0], addr[1], addr[2], addr[3]);
//            #endif
      		wiz_read_buf(s, buf, data_len+(data_len & 0x01)); // data copy.
   			break;
   	case Sn_MR_MACRAW :
   	   {
   			wiz_read_buf(s,(uint16*)head,2);
   			if(*((vuint16*)MR) & MR_FIFOSWAP)
   			   head[0] = ((((head[0] << 8 ) & 0xFF00)) | ((head[0] >> 8)& 0x00FF));
   			data_len = (uint32)head[0];
      		wiz_read_buf(s, buf, data_len+(data_len & 0x01)); // data copy.
      		wiz_read_buf(s, crc, 4);   // CRC Data is ignored.
//      		{
//      		   uint16 last;
//      		   last = (data_len + (data_len & 0x01))/2 - 1;
//      			printf("MAC RAW msg arrived(%d,0x%04x)\r\n",data_len,data_len);
//      			printf("dest mac=%02x.%02x.%02x.%02x.%02x.%02x\r\n",(uint8)(buf[0]>>8),(uint8)buf[0],(uint8)(buf[1]>>8),(uint8)buf[1],(uint8)(buf[2]>>8),(uint8)buf[2]);
//      			printf("src  mac=%02x.%02x.%02x.%02x.%02x.%02x\r\n",(uint8)(buf[3]>>8),(uint8)buf[3],(uint8)(buf[4]>>8),(uint8)buf[4],(uint8)(buf[5]>>8),(uint8)buf[5]);
//      			printf("type    =%02x%02x\r\n",(uint8)(buf[6]>> 8),(uint8)buf[6]); 
//      			printf("crc     =%04x%04x\r\n",crc[0],crc[1]);
//      			printf("lastdata=%04x %04x %04x %04x:last=%d\r\n", buf[last-3],buf[last-2],buf[last-1],buf[last],last);
//      		}
      	}
			break;
   	default :
   			break;
   	}
		IINCHIP_WRITE(Sn_CR(s),Sn_CR_RECV);
      while(IINCHIP_READ(Sn_CR(s)));
   }
   
 	return data_len;   
}
