#include <common.h>
#include <command.h>
#include "w5300.h"
#include "socket.h"
#include <net.h>
#include <w5300_mac.h>

#if (CONFIG_DRIVER_W5300)

#define MAX_BUFFER_SIZE	32768

static void loopback(u16 port)
{
	u8 ssr = 0;
	uint32 len;
	u16 data_buf[MAX_BUFFER_SIZE>>1];
	
	ssr = getSn_SSR(1);
	switch(ssr)
	{
	case SOCK_INIT:
		printf("Socket Status : SOCK_INIT\n");
		listen(1);
		break;
	case SOCK_ESTABLISHED:
		len = getSn_RX_RSR(1);
		if(len > 0) {
			if(len > MAX_BUFFER_SIZE) len = MAX_BUFFER_SIZE;
			len = recv(1, data_buf, len);
			send(1, data_buf, len);
		}
		break;
	case SOCK_CLOSE_WAIT:
		printf("Socket Status : CLOSE_WAIT\n");
		disconnect(1);
		break;
	case SOCK_CLOSED:
		printf("Socket Status : SOCK_CLOSED\n");
		if(socket(1, Sn_MR_TCP, port, Sn_MR_ND|Sn_MR_ALIGN) == 0)
		{
			printf("Fail to create socket.\n");
		}
		break;
	default:
		break;
	}

	return;
}

int do_loopback (cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	DECLARE_GLOBAL_DATA_PTR;

	bd_t *bd = gd->bd;

	u16 port;
	if(argc != 2) {
		printf ("Usage:\n%s\n", cmdtp->usage);
		return 1;
	}

	port = simple_strtoul(argv[1], NULL, 10);
	printf("Using port:%d\n", port);

	if(eth_init(bd)<0) {
		printf("Ethernet initializing fail\n");
		eth_halt();
		return -1;
	}

	while(1) {
		loopback(port);
		if(ctrlc()) {
			eth_halt();
			return -1;
		}
	}

	eth_halt();
	return 0;
}

U_BOOT_CMD(
	loopback,	2,	0,	do_loopback,
	"loopback- loopback server\n",
	"Port\n"
	"    - loopback server\n"
);

#endif

