/*
*
@file		lcd.h
@brief	LCD Basic Function Definition
*/

#ifndef _LCD_H
#define _LCD_H


#define LCD_MAX_COL		16
#define LCD_MAX_ROW		2

#define LCD_BASEADDR		0x18000000

#define LcdCommandW (*((volatile unsigned char*)LCD_BASEADDR))	/**< LCD Command Write Register */
#define LcdCommandR (*((volatile unsigned char*)(LCD_BASEADDR+1)))	/**< LCD Command Read Register */


#define LcdDataW    (*((volatile unsigned char*)(LCD_BASEADDR+2)))	/**< LCD Data Write Register */
#define LcdDataR    (*((volatile unsigned char*)(LCD_BASEADDR+3)))	/**< LCD Data Read Register */


/* If there are unused functions in program and on compiling with Keil-C, it result in warning.In this reason, wrong operation could be happend.
So it prevent to compile unused functions to use define-function.
*/
#define __LCD_UNUSED   /**< If defined with " __LCD_UNUSED", actually it's not to be compiled "__LCD_UNUSED Block" */


extern char lcd_ready(void);			// Check for LCD to be ready
extern void lcd_clrscr(void);			// Clear LCD. 
extern char lcd_init(void);			// LCD Init
extern void lcd_gotoxy(unsigned int x, unsigned int y);	// Output character string in current Cursor.
extern char* lcd_puts(char* str);		// Output character stream in current Cursor.
extern void lcd_putch(char ch);		// Output 1 character in current Cursor.



#ifndef __LCD_UNUSED

extern void lcd_home_cursor(void);		// Move Cursor first Column.
extern void lcd_set_cursor_type(unsigned int type);	// Decide Cursor type.
extern void lcd_shitf_cursor(unsigned int dir);	// Shift to Left and Right current Cursor.

#endif

#endif
